# Project 2: Distributed gRPC Calculator

This project is a distributed numerical calculator system (addition and multiplication) built with gRPC. It features services written in different languages (Python, Go, and Java) that communicate with each other.

## Project Structure

* `/proto`: Contains the unified `.proto` contract file (`calculator.proto`).
* `/addition_service`: The Addition Service, written in **Python**.
* `/multiplication_service`: The Multiplication Service, written in **Go**.
* `/src/main/java`: The Client Gateway, written in **Java**.
* `README.md`: This documentation file.

##  How to Run the Project

To run the full project, you must run all 3 components in **3 separate Terminal windows**, in order.

### 1. Run the Addition Service (Python)

1.  Open a Terminal.
2.  Navigate to the service directory:
    ```bash
    cd addition_service
    ```
3.  (First time only) Install dependencies:
    ```bash
    pip install grpcio grpcio-tools
    ```
4.  Run the server (it will keep running on port `50051`):
    ```bash
    python server.py
    ```
    * *Expected output: `Addition Service server started on port 50051...`*

### 2. Run the Multiplication Service (Go)

1.  Open a **new, separate** Terminal.
2.  Navigate to the service directory:
    ```bash
    cd multiplication_service
    ```
3.  (First time only) Download dependencies:
    ```bash
    go mod tidy
    ```
4.  Run the server (it will keep running on port `50052`):
    ```bash
    go run server.go
    ```
    * *Expected output: `Multiplication Service server started on port 50052...`*

### 3. Run the Java Gateway (Client)

1.  Ensure both the Python and Go servers are running in their terminals.
2.  Open the project in IntelliJ IDEA.
3.  Open the `ClientGateway.java` file located at:
    `src/main/java/com/example/grpc/calculator/ClientGateway.java`
4.  Right-click anywhere in the code and select **"Run 'ClientGateway.main()'"**.

##  Example Input/Output

Once the Java client is running, it will become interactive in the "Run" console window.

1.  **Input (Option 1):**
    ```
    Enter your choice: 1
    Enter number 1: 10
    Enter number 2: 5
    ```
2.  **Output (The Result):**
    ```
    Calling services with num1=10, num2=5
    Addition Result (from Python): 15
    Multiplication Result (from Go): 50
    ```

---

1.  **Input (Option 2):**
    ```
    Enter your choice: 2
    ```
2.  **Output (The Streaming Log):**
    ```
    --- Fetching Addition Log (Python) ---
    Add Operation: 10 + 5 = 15
    
    --- Fetching Multiplication Log (Go) ---
    Multiply Operation: 10 * 5 = 50
    ```