package com.search.project;

import com.search.project.proto.SearchRequest;
import com.search.project.proto.SearchResponse;
import com.search.project.proto.SearchServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;

public class SearchServiceImplementation extends SearchServiceGrpc.SearchServiceImplBase {
    private static final String DATA_DIR = "src/main/resources";

    @Override
    public void processSearch(SearchRequest request, StreamObserver<SearchResponse> responseObserver) {
        // 1. تقطيع جملة البحث لعدة كلمات
        String[] queryWords = request.getQuery().toLowerCase().split("\\W+");
        SearchResponse.Builder responseBuilder = SearchResponse.newBuilder();

        for (String fileName : request.getFileNamesList()) {
            try {
                File file = new File(DATA_DIR, fileName);
                if (!file.exists()) continue;

                String content = Files.readString(file.toPath()).toLowerCase();
                String[] docWords = content.split("\\W+");

                double totalSentenceScore = 0;

                // 2. نحسب الـ TF لكل كلمة من كلمات البحث ونجمعهم
                for (String qWord : queryWords) {
                    if (qWord.isEmpty()) continue;

                    long count = Arrays.stream(docWords).filter(w -> w.equals(qWord)).count();
                    double tf = (docWords.length > 0) ? (double) count / docWords.length : 0;

                    totalSentenceScore += tf; // نجمع الأوزان
                }


                if (totalSentenceScore > 0) {
                    SearchResponse.DocumentScore docScore = SearchResponse.DocumentScore.newBuilder()
                            .setDocName(fileName)
                            .setScore(totalSentenceScore)
                            .build();
                    responseBuilder.addResults(docScore);
                }
            } catch (Exception e) {
                System.err.println("Error reading: " + fileName);
            }
        }

        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }
}