package com.search.project;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.zookeeper.CreateMode;
import java.net.InetAddress;
import java.util.List;

public class ServiceRegistry {
    private static final String ELECTION_PATH = "/election";
    private static final String REGISTRY_PATH = "/service_registry";
    private final CuratorFramework client;

    public ServiceRegistry(CuratorFramework client) {
        this.client = client;
    }

    public void startLeaderElection(Runnable onLeadershipGained) {
        LeaderSelector leaderSelector = new LeaderSelector(client, ELECTION_PATH, new LeaderSelectorListenerAdapter() {
            @Override
            public void takeLeadership(CuratorFramework client) throws Exception {
                onLeadershipGained.run();
                try {
                    Thread.sleep(Long.MAX_VALUE);
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        leaderSelector.autoRequeue();
        leaderSelector.start();
    }

    public void registerToCluster(String metadata) throws Exception {
        if (client.checkExists().forPath(REGISTRY_PATH) == null) {
            client.create().creatingParentsIfNeeded().forPath(REGISTRY_PATH);
        }
        client.create()
                .withMode(CreateMode.EPHEMERAL_SEQUENTIAL)
                .forPath(REGISTRY_PATH + "/worker_", metadata.getBytes());
    }

    public List<String> getAllWorkers() throws Exception {
        if (client.checkExists().forPath(REGISTRY_PATH) == null) return List.of();
        return client.getChildren().forPath(REGISTRY_PATH);
    }
}