package com.search.project;

import com.search.project.proto.SearchRequest;
import com.search.project.proto.SearchResponse;
import com.search.project.proto.SearchServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;

public class SearchServiceImplementation extends SearchServiceGrpc.SearchServiceImplBase {
    private static final String DATA_DIR = "D:/search_data"; // تأكدي من وجود المجلد وبعض ملفات .txt

    @Override
    public void processSearch(SearchRequest request, StreamObserver<SearchResponse> responseObserver) {
        String query = request.getQuery().toLowerCase();
        StringBuilder results = new StringBuilder();

        File dir = new File(DATA_DIR);
        File[] files = dir.listFiles((d, name) -> name.endsWith(".txt"));

        if (files != null) {
            for (File file : files) {
                try {
                    String content = Files.readString(file.toPath()).toLowerCase();
                    String[] words = content.split("\\W+");
                    long count = Arrays.stream(words).filter(w -> w.equals(query)).count();
                    double tf = (words.length > 0) ? (double) count / words.length : 0;

                    if (tf > 0) {
                        results.append(String.format("File: %-12s | Score: %.4f\n", file.getName(), tf));
                    }
                } catch (Exception e) {
                    results.append("Error reading: ").append(file.getName()).append("\n");
                }
            }
        }

        String finalMsg = results.length() > 0 ? results.toString() : "No results found.";
        responseObserver.onNext(SearchResponse.newBuilder().setResult(finalMsg).build());
        responseObserver.onCompleted();
    }
}