package com.search.project;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class Application {
    private static final String ZK_ADDRESS = "172.29.3.101:2181";

    public static void main(String[] args) throws Exception {
        CuratorFramework client = CuratorFrameworkFactory.newClient(ZK_ADDRESS, new ExponentialBackoffRetry(1000, 3));
        client.start();

        ServiceRegistry registry = new ServiceRegistry(client);

        // 1. تشغيل العقدة كـ "عامل"
        new Thread(() -> {
            try { WorkerNode.start(registry); } catch (Exception e) { e.printStackTrace(); }
        }).start();

        // 2. بدء الانتخاب
        registry.startLeaderElection(() -> {
            System.out.println("\n[Coordinator] مبروك! هذه العقدة أصبحت القائد الآن.");
            try {
                FrontendServer.start(client, registry);
            } catch (Exception e) { e.printStackTrace(); }
        });

        Thread.currentThread().join();
    }
}