package com.search.project;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.net.InetAddress;
import java.net.ServerSocket;

public class WorkerNode {
    // لحفظ المنفذ الحالي للعقدة
    public static int serverPort = -1;

    public static void start(ServiceRegistry registry) throws Exception {
        int port;
        // حجز منفذ ديناميكي
        try (ServerSocket socket = new ServerSocket(0)) {
            port = socket.getLocalPort();
        }

        // حفظ المنفذ في المتغير العام لاستخدامه في الفلترة عند المنسق
        serverPort = port;

        String myAddress = InetAddress.getLocalHost().getHostAddress() + ":" + port;

        // تسجيل العقدة في زوكيبر
        registry.registerToCluster(myAddress);

        // بناء وتشغيل سيرفر gRPC
        Server server = ServerBuilder.forPort(port)
                .addService(new SearchServiceImplementation())
                .build();

        System.out.println("[Worker] العامل جاهز على: " + myAddress);
        server.start();
    }
}