/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ClusterScheduler
implements Watcher {
    private ZooKeeper zk;
    private final int totalWorkersRequired = 10;
    private static final String ZOOKEEPER_ADDRESS = "192.168.184.101:2181,192.168.184.102:2181,192.168.184.103:2181";

    public void connect() throws IOException {
        this.zk = new ZooKeeper(ZOOKEEPER_ADDRESS, 5000, this);
    }

    public void manageCluster() throws KeeperException, InterruptedException {
        this.ensurePathExists("/nodes");
        this.ensurePathExists("/tasks");
        List<String> availableNodes = this.zk.getChildren("/nodes", true);
        if (availableNodes.isEmpty()) {
            System.out.println("Waiting for Agents to join...");
            return;
        }
        int workersPerNode = 10 / availableNodes.size();
        int extraWorkers = 10 % availableNodes.size();
        for (String node : availableNodes) {
            int count = workersPerNode + (extraWorkers-- > 0 ? 1 : 0);
            this.updateNodeTask(node, count);
        }
    }

    private void updateNodeTask(String nodeIP, int count) throws KeeperException, InterruptedException {
        String path = "/tasks/" + nodeIP;
        String data = String.valueOf(count);
        if (this.zk.exists(path, false) == null) {
            this.zk.create(path, data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        } else {
            this.zk.setData(path, data.getBytes(), -1);
        }
        System.out.println("Assigned " + count + " workers to Node: " + nodeIP);
        this.logEvent("Scheduled " + count + " workers on " + nodeIP);
    }

    private void ensurePathExists(String path) throws KeeperException, InterruptedException {
        if (this.zk.exists(path, false) == null) {
            this.zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    private void logEvent(String message) {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("cluster_status.log", true)));){
            out.println(new Date() + " - " + message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged && event.getPath().equals("/nodes")) {
            try {
                this.manageCluster();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ClusterScheduler scheduler = new ClusterScheduler();
        scheduler.connect();
        scheduler.manageCluster();
        Thread.sleep(Long.MAX_VALUE);
    }
}

