/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class NodeAgent
implements Watcher {
    private static final String ZOOKEEPER_ADDRESS = "192.168.144.134:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String NODES_ROOT = "/nodes";
    private static final String WORKER_JAR_PATH = "D:\\fifth year\\DS\\auto-healer-zookeper\\transientworker\\target\\transientworker-1.0-SNAPSHOT.jar";
    private ZooKeeper zooKeeper;
    private String myTasksPath;

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ZOOKEEPER_ADDRESS, 3000, (Watcher)this);
    }

    public void registerNodeAndWatchTasks() throws KeeperException, InterruptedException, IOException {
        this.ensurePath(NODES_ROOT, CreateMode.PERSISTENT);
        String ipAddress = InetAddress.getLocalHost().getHostAddress();
        String nodePath = "/nodes/node_" + ipAddress;
        this.ensurePath(nodePath, CreateMode.PERSISTENT);
        String activePath = nodePath + "/active";
        if (this.zooKeeper.exists(activePath, false) == null) {
            this.zooKeeper.create(activePath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        this.myTasksPath = nodePath + "/tasks";
        this.ensurePath(this.myTasksPath, CreateMode.PERSISTENT);
        System.out.println("Node Registered: " + nodePath + ". Watching tasks at: " + this.myTasksPath);
        this.watchMyTasks();
    }

    private void ensurePath(String path, CreateMode mode) throws KeeperException, InterruptedException {
        if (this.zooKeeper.exists(path, false) == null) {
            this.zooKeeper.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
        }
    }

    private void watchMyTasks() throws KeeperException, InterruptedException {
        List tasks = this.zooKeeper.getChildren(this.myTasksPath, (Watcher)this);
        System.out.println("Current tasks count: " + tasks.size());
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged && event.getPath().equals(this.myTasksPath)) {
            this.handleNewTask();
        } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            System.out.println("Connected to Zookeeper");
        }
    }

    private void handleNewTask() {
        try {
            this.startLocalWorker();
            this.watchMyTasks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startLocalWorker() throws IOException {
        File jarFile = new File(WORKER_JAR_PATH);
        ProcessBuilder pb = new ProcessBuilder("java", "-jar", jarFile.getAbsolutePath());
        pb.inheritIO();
        pb.directory(jarFile.getParentFile());
        System.out.println("New worker launched locally!");
        pb.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NodeAgent agent = new NodeAgent();
        agent.connectToZookeeper();
        agent.registerNodeAndWatchTasks();
        ZooKeeper zooKeeper = agent.zooKeeper;
        synchronized (zooKeeper) {
            agent.zooKeeper.wait();
        }
    }
}

