import 'package:flutter/material.dart';
import 'package:meals/screens/category_meal_screen.dart';

class Categoryitem extends StatelessWidget {
  void slectmeal(BuildContext ctx) {
    Navigator.of(
      ctx,
    ).pushNamed(CateGorymeal.routename, arguments: {'id': id, 'title': title});
  }

  final String id;
  final String title;
  final Color color;

  Categoryitem({required this.id, required this.title, required this.color});

  @override
  Widget build(BuildContext context) {
    return Material(
      color: Colors.transparent, // Important for ripple effect
      child: InkWell(
        onTap: () => slectmeal(context),
        borderRadius: BorderRadius.circular(
          15,
        ), // Match container border radius
        splashColor: Theme.of(context).primaryColor, // Customize ripple color
        child: Container(
          padding: EdgeInsets.all(15),
          decoration: BoxDecoration(
            gradient: LinearGradient(
              colors: [color.withOpacity(0.3), color],
              begin: Alignment.topLeft,
              end: Alignment.bottomRight,
            ),
            borderRadius: BorderRadius.circular(15),
          ),
          child: Column(
            children: [
              Text(title, style: Theme.of(context).textTheme.titleLarge),
              Text(id, style: Theme.of(context).textTheme.titleLarge),
            ],
          ),
        ),
      ),
    );
  }
}
