import 'package:flutter/material.dart';
import '../models/meal.dart';
import '../screens/favourate_meal_screen.dart';
import '../screens/CateGoriesscreen.dart';
import '../widget/main_drawer.dart';

class TapsScreen extends StatefulWidget {
  final List<Meal> favouratemeals;
  TapsScreen(this.favouratemeals);

  @override
  State<TapsScreen> createState() => _TapsScreenState();
}

class _TapsScreenState extends State<TapsScreen> {
  late List<Map<String, dynamic>> pages;

  int _selectedIndex = 0;
  @override
  void initState() {
    pages = [
      {'page': Categoriesscreen(), 'title': 'Categories'},
      {
        'page': FavourateMealScreen(widget.favouratemeals),
        'title': 'Your Favorites',
      },
    ];
    super.initState();
  }

  void _selectPage(int index) {
    setState(() {
      _selectedIndex = index;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: Text(pages[_selectedIndex]['title'])),
      body: pages[_selectedIndex]['page'],
      bottomNavigationBar: BottomNavigationBar(
        backgroundColor: Theme.of(context).primaryColor,
        selectedItemColor: Theme.of(context).colorScheme.secondary,
        unselectedItemColor: Colors.white,
        currentIndex: _selectedIndex,
        onTap: _selectPage,
        items: const [
          BottomNavigationBarItem(
            icon: Icon(Icons.category),
            label: "Categories",
          ),
          BottomNavigationBarItem(
            icon: Icon(Icons.favorite),
            label: "Favorites",
          ),
        ],
      ),
      drawer: MainDrawer(),
    );
  }
}
