// ignore_for_file: no_leading_underscores_for_local_identifiers

import 'package:flutter/material.dart';
import '../1.1%20dummy_data.dart';
import '../models/meal.dart';
import '../screens/meal_detials_screen.dart';
import '../screens/new_screen.dart';
import '../screens/taps_screen.dart';
import '../screens/category_meal_screen.dart';

void main() {
  runApp(MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  // ignore: prefer_final_fields
  Map<String, bool> _filters = {
    'gluten': false,
    'lactase': false,
    'vegetarian': false,
    'vegan': false,
  };
  List<Meal> _availableMeals = DUMMY_MEALS;
  List<Meal> _favouratemeals = [];
  void _tagglefavorite(String mealId) {
    final _indexvalue = _favouratemeals.indexWhere((meal) => meal.id == mealId);
    if (_indexvalue >= 0) {
      setState(() {
        _favouratemeals.removeAt(_indexvalue);
      });
    } else {
      setState(() {
        _favouratemeals.add(
          DUMMY_MEALS.firstWhere((meal) => meal.id == mealId),
        );
      });
    }
  }

  bool _isfavorite(String id) {
    return _favouratemeals.any((meal) => meal.id == id);
  }

  // ignore: unused_element
  void _savefilters(Map<String, bool> _filterData) {
    setState(() {
      _filters = _filterData;

      _availableMeals = DUMMY_MEALS.where((meal) {
        if (_filters['gluten']! && !meal.isGlutenFree) {
          return false;
        }
        if (_filters['lactose']! && !meal.isLactoseFree) {
          return false;
        }
        if (_filters['vegan']! && !meal.isVegan) {
          return false;
        }
        if (_filters['vegetarian']! && !meal.isVegetarian) {
          return false;
        }
        return true;
      }).toList();
    });
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      title: "Flutter Demo",
      theme: ThemeData(
        primarySwatch: Colors.amber,
        primaryColor: Colors.pink, // Add this line
        hintColor: Colors.amber,
        canvasColor: Color.fromRGBO(232, 255, 229, 0),
        textTheme: ThemeData.light().textTheme.copyWith(
          bodyLarge: TextStyle(color: Color.fromRGBO(20, 50, 58, 1)),
          bodyMedium: TextStyle(color: Color.fromRGBO(20, 50, 58, 1)),
          titleLarge: TextStyle(
            fontFamily: 'RobotoCondensed',
            fontSize: 20,
            fontWeight: FontWeight.bold,
          ),
        ),
      ),
      //home: HomePage(),
      //home: Categoriesscreen(),
      routes: {
        '/': (context) {
          return TapsScreen(_favouratemeals);
        },
        FillterScreen.routename: (context) {
          return FillterScreen(_savefilters);
        },
        CateGorymeal.routename: (context) {
          return CateGorymeal(_availableMeals);
        },
        MealDetialsScreen.routename: (context) {
          return MealDetialsScreen(_isfavorite, _tagglefavorite);
        },
      },
    );
  }
}

class HomePage extends StatefulWidget {
  const HomePage({super.key});

  @override
  State<StatefulWidget> createState() {
    return HomePagestate();
  }
}

class HomePagestate extends State<HomePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(appBar: AppBar(title: Text("Meal App")), body: null);
  }
}
