import 'package:flutter/material.dart';
import 'package:meals/widget/main_drawer.dart';

class FillterScreen extends StatefulWidget {
  static const routename = '/filters';
  final Function(Map<String, bool>) savefilters;
  FillterScreen(this.savefilters);

  @override
  State<FillterScreen> createState() => _FillterScreenState();
}

class _FillterScreenState extends State<FillterScreen> {
  bool _GlutenFree = false;
  bool _LactoseFree = false;
  bool _Vegan = false;
  bool _Vegetarian = false;

  Widget buildSwitchListTile(
    String title,
    bool currentValue,
    String moreInformation,
    Function(bool) updateValue,
  ) {
    return SwitchListTile(
      value: currentValue,
      title: Text(title, style: Theme.of(context).textTheme.titleLarge),
      subtitle: Text(moreInformation),
      onChanged: updateValue, // ✅ FIXED - pass function reference
    );
  }

  void _saveFilters() {
    final Map<String, bool> selectedFilters = {
      'gluten': _GlutenFree,
      'lactose': _LactoseFree,
      'vegan': _Vegan,
      'vegetarian': _Vegetarian,
    };
    widget.savefilters(selectedFilters);
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("Your Filters"),
        backgroundColor: Colors.pinkAccent,
        actions: [
          IconButton(
            onPressed: _saveFilters,
            icon: Icon(Icons.save),
            color: Colors.white,
          ),
        ],
      ),
      body: Column(
        children: [
          Container(
            padding: EdgeInsets.all(20),
            child: Text(
              "Adjust your meal selection",
              style: Theme.of(context).textTheme.titleLarge,
            ),
          ),
          Expanded(
            child: ListView(
              children: [
                buildSwitchListTile(
                  "Gluten-Free",
                  _GlutenFree,
                  "Only include gluten-free meals",
                  (newValue) => setState(() => _GlutenFree = newValue),
                ),
                buildSwitchListTile(
                  "Lactose-Free",
                  _LactoseFree,
                  "Only include lactose-free meals",
                  (newValue) => setState(() => _LactoseFree = newValue),
                ),
                buildSwitchListTile(
                  "Vegetarian",
                  _Vegetarian,
                  "Only include vegetarian meals",
                  (newValue) => setState(() => _Vegetarian = newValue),
                ),
                buildSwitchListTile(
                  "Vegan",
                  _Vegan,
                  "Only include vegan meals",
                  (newValue) => setState(() => _Vegan = newValue),
                ),
              ],
            ),
          ),
        ],
      ),
      drawer: MainDrawer(),
    );
  }
}
