import 'package:flutter/material.dart';
import '../1.1 dummy_data.dart';

class MealDetialsScreen extends StatelessWidget {
  static const routename = 'Meal Detials';
  final Function(String) togglefavorite;
  final Function(String) isfavorite;

  MealDetialsScreen(this.isfavorite, this.togglefavorite);

  Widget sleckttitle(String x, BuildContext ctx) {
    return Container(
      margin: EdgeInsets.symmetric(vertical: 10),
      child: Text(x, style: Theme.of(ctx).textTheme.titleLarge),
    );
  }

  Widget buildcontainer(Widget child) {
    return Container(
      decoration: BoxDecoration(
        color: Colors.white,
        border: Border.all(color: Colors.grey),
        borderRadius: BorderRadius.circular(10),
      ),
      margin: EdgeInsets.all(10),
      padding: EdgeInsets.all(10),
      height: 200,
      width: 300,
      child: child,
    );
  }

  @override
  Widget build(BuildContext context) {
    final routemeal =
        ModalRoute.of(context)!.settings.arguments as Map<String, String>;

    final detailsmeal = DUMMY_MEALS.firstWhere(
      (meal) => meal.id == routemeal['id'],
    );
    final String mealId = detailsmeal.id; // Make final and local

    return Scaffold(
      appBar: AppBar(
        title: Text(detailsmeal.title),
        backgroundColor: Colors.pinkAccent,
        actions: [
          IconButton(
            icon: Icon(
              isfavorite(mealId) ? Icons.favorite : Icons.favorite_border,
              color: Colors.white,
            ),
            onPressed: () => togglefavorite(mealId),
          ),
        ],
      ),
      body: SingleChildScrollView(
        child: Column(
          children: [
            Container(
              height: 300,
              width: double.infinity,
              child: Image.network(
                detailsmeal.imageUrl,
                fit: BoxFit.cover,
                errorBuilder: (context, error, stackTrace) {
                  return Container(
                    color: Colors.grey[300],
                    child: Icon(Icons.error, size: 50),
                  );
                },
              ),
            ),
            sleckttitle("Ingredients", context),
            buildcontainer(
              ListView.builder(
                itemBuilder: (ctx, index) => Card(
                  color: Colors.amberAccent,
                  child: Padding(
                    padding: EdgeInsets.all(8),
                    child: Text(detailsmeal.ingredients[index]),
                  ),
                ),
                itemCount: detailsmeal.ingredients.length,
              ),
            ),
            sleckttitle("Steps", context),
            buildcontainer(
              ListView.builder(
                itemBuilder: (ctx, index) => Column(
                  children: [
                    ListTile(
                      leading: CircleAvatar(child: Text("#${index + 1}")),
                      title: Text(
                        detailsmeal.steps[index],
                        style: TextStyle(color: Colors.black),
                      ),
                    ),
                    Divider(),
                  ],
                ),
                itemCount: detailsmeal.steps.length,
              ),
            ),
          ],
        ),
      ),
      floatingActionButton: FloatingActionButton(
        onPressed: () => togglefavorite(mealId),
        child: Icon(isfavorite(mealId) ? Icons.star : Icons.star_border),
      ),
    );
  }
}
