import 'package:flutter/material.dart';
import '../models/meal.dart';
import '../screens/meal_screen.dart';

class FavourateMealScreen extends StatelessWidget {
  final List<Meal> favoriteMeals;
  FavourateMealScreen(this.favoriteMeals);

  @override
  Widget build(BuildContext context) {
    if (favoriteMeals.isEmpty) {
      return Center(
        child: Text("You have no favorites yet - start adding some!"),
      ); // Center
    } else {
      return ListView.builder(
        itemBuilder: (ctx, index) {
          return MealScreen(
            id: favoriteMeals[index].id,
            imageUrl: favoriteMeals[index].imageUrl,
            title: favoriteMeals[index].title,
            duration: favoriteMeals[index].duration,
            complexity: favoriteMeals[index].complexity,
            affordability: favoriteMeals[index].affordability,
          ); // MealItem
        },
        itemCount: favoriteMeals.length,
      ); // ListView.builder
    }
  }
}
