import 'package:flutter/material.dart';
import '../models/meal.dart';
import '../screens/meal_screen.dart';
//import '../1.1 dummy_data.dart';

class CateGorymeal extends StatefulWidget {
  static const routename = 'CateGory_meal';
  final List<Meal> _Meals;
  CateGorymeal(this._Meals);

  @override
  State<CateGorymeal> createState() => _CateGorymealState();
}

class _CateGorymealState extends State<CateGorymeal> {
  String categorytitle = "x";
  List<Meal> displaymeals = [];
  bool _isInitialized = false; // Track if we've initialized

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();

    // Only run once when first loaded
    if (!_isInitialized) {
      final routArg =
          ModalRoute.of(context)?.settings.arguments as Map<String, String>?;

      if (routArg != null) {
        final String categoryId = routArg['id'] as String;
        categorytitle = routArg['title'] as String;

        displaymeals = widget._Meals.where((meal) {
          return meal.categories.contains(categoryId);
        }).toList();

        print('Initial meals:');
        for (var meal in displaymeals) {
          print(meal.id);
        }

        _isInitialized = true; // Mark as initialized
      }
    }
  }

  // void _removemeal(String mealId) {
  //   setState(() {
  //     displaymeals.removeWhere((meal) => meal.id == mealId);

  //     print('After removal:');
  //     for (var meal in displaymeals) {
  //       print(meal.id);
  //     }
  //   });
  // }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(categorytitle, style: TextStyle()),
        backgroundColor: Colors.blue,
      ),
      body: ListView.builder(
        itemCount: displaymeals.length, // Added itemCount
        itemBuilder: (ctx, index) {
          return MealScreen(
            id: displaymeals[index].id,
            imageUrl: displaymeals[index].imageUrl,
            title: displaymeals[index].title,
            duration: displaymeals[index].duration,
            complexity: displaymeals[index].complexity,
            affordability: displaymeals[index].affordability,
            // removeitem: _removemeal,
          );
          // Added missing closing parenthesis
        },
      ),
    );
  }
}
