/*
 * Decompiled with CFR 0.152.
 */
package AutoHealerAndLoadBalancing;

import AutoHealerAndLoadBalancing.OnElectionCallback;
import AutoHealerAndLoadBalancing.ServiceRegistry;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnElectionAction
implements OnElectionCallback {
    private final Logger logger = LoggerFactory.getLogger(OnElectionAction.class);
    private final ServiceRegistry serviceRegistry;
    private final int port;

    public OnElectionAction(ServiceRegistry serviceRegistry, int port) {
        this.serviceRegistry = serviceRegistry;
        this.port = port;
    }

    @Override
    public void onElectedToBeLeader() {
        this.serviceRegistry.unregisterFromCluster();
        this.serviceRegistry.registerForUpdates();
    }

    @Override
    public void onWorker(String IP) {
        try {
            this.serviceRegistry.registerToCluster(IP);
        }
        catch (InterruptedException | KeeperException e) {
            this.logger.error("Could Not Register To Cluster");
            e.printStackTrace();
        }
    }
}

