/*
 * Decompiled with CFR 0.152.
 */
package AutoHealerAndLoadBalancing;

import AutoHealerAndLoadBalancing.NodeSorting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry
implements Watcher {
    private static final String WORKERS_ZNODES_PATH = "/workers";
    private static final String PHYSICAL_ZNODES_PATH = "/physical_nodes";
    private final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private String pathToProgram = "";
    private final ZooKeeper zooKeeper;
    private String currentZnode = null;
    private List<String> allServiceAddresses = null;
    private int numberOfInstances;

    public ServiceRegistry(ZooKeeper zooKeeper, int numberOfInstances, String pathToProgram) {
        this.zooKeeper = zooKeeper;
        this.numberOfInstances = numberOfInstances;
        this.pathToProgram = pathToProgram;
        this.createServiceRegistryZnode();
    }

    private void createServiceRegistryZnode() {
        try {
            if (this.zooKeeper.exists(WORKERS_ZNODES_PATH, false) == null) {
                this.zooKeeper.create(WORKERS_ZNODES_PATH, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (this.zooKeeper.exists(PHYSICAL_ZNODES_PATH, false) == null) {
                this.zooKeeper.create(PHYSICAL_ZNODES_PATH, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (InterruptedException | KeeperException e) {
            this.logger.error("Could NOT Create Service Registry Znode");
            e.printStackTrace();
        }
    }

    public void registerToCluster(String metadata) throws KeeperException, InterruptedException {
        if (this.currentZnode != null) {
            this.logger.info("Already registered to service registry");
            return;
        }
        this.currentZnode = this.zooKeeper.create("/physical_nodes/physical_node_", metadata.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        this.logger.info("Registered to service registry");
    }

    public void registerForUpdates() {
        try {
            this.masterJob();
        }
        catch (IOException | InterruptedException | KeeperException e) {
            this.logger.error("Could Not Do LEADER JOB !");
            e.printStackTrace();
        }
    }

    public void unregisterFromCluster() {
        try {
            if (this.currentZnode != null && this.zooKeeper.exists(this.currentZnode, false) != null) {
                this.zooKeeper.delete(this.currentZnode, -1);
            }
        }
        catch (InterruptedException | KeeperException e) {
            this.logger.error("Could Not UN-Register From Cluster !!");
            e.printStackTrace();
        }
    }

    private synchronized void masterJob() throws InterruptedException, KeeperException, IOException {
        this.updateAddresses();
        this.launchWorkersIfNecessary();
    }

    private void updateAddresses() throws KeeperException, InterruptedException {
        List<String> workerZnodes = this.zooKeeper.getChildren(PHYSICAL_ZNODES_PATH, false);
        ArrayList<String> addresses = new ArrayList<String>(workerZnodes.size());
        for (String workerZnode : workerZnodes) {
            String workerFullPath = "/physical_nodes/" + workerZnode;
            Stat stat = this.zooKeeper.exists(workerFullPath, false);
            if (stat == null) continue;
            byte[] addressBytes = this.zooKeeper.getData(workerFullPath, false, stat);
            String address = new String(addressBytes);
            addresses.add(address);
        }
        this.allServiceAddresses = Collections.unmodifiableList(addresses);
        this.logger.info("The cluster addresses are: " + this.allServiceAddresses);
    }

    private void launchWorkersIfNecessary() throws KeeperException, InterruptedException, IOException {
        List<String> physicalZnodes = this.zooKeeper.getChildren(PHYSICAL_ZNODES_PATH, this);
        List<String> workers = this.zooKeeper.getChildren(WORKERS_ZNODES_PATH, this);
        for (String worker : workers) {
            Stat stat = this.zooKeeper.exists("/workers/" + worker, false);
            if (stat == null) {
                workers.remove(worker);
                continue;
            }
            String node = new String(this.zooKeeper.getData("/workers/" + worker, false, stat));
            if (physicalZnodes.contains(node)) continue;
            workers.remove(worker);
        }
        List<String> sortedWorkers = NodeSorting.sort(this.getOriginalNodes(workers), physicalZnodes);
        while (workers.size() > this.numberOfInstances) {
            Stat stat = this.zooKeeper.exists("/workers/" + workers.get(0), false);
            if (stat == null) {
                workers.remove(0);
                continue;
            }
            this.zooKeeper.delete("/workers/" + workers.get(0), -1);
        }
        int neededInstances = this.numberOfInstances - workers.size();
        if (neededInstances <= 0) {
            return;
        }
        int index = 0;
        int size = sortedWorkers.size();
        while (neededInstances > 0 && size > 0) {
            Stat stat = this.zooKeeper.exists("/physical_nodes/" + sortedWorkers.get(index), false);
            if (stat == null) {
                sortedWorkers.remove(index);
                --size;
                continue;
            }
            this.startNewWorker(sortedWorkers.get(index));
            --neededInstances;
            index = (index + 1) % size;
        }
    }

    private List<byte[]> getOriginalNodes(List<String> workers) throws InterruptedException, KeeperException {
        ArrayList<byte[]> ans = new ArrayList<byte[]>();
        for (String worker : workers) {
            Stat stat = this.zooKeeper.exists("/workers/" + worker, false);
            if (stat == null) continue;
            ans.add(this.zooKeeper.getData("/workers/" + worker, false, stat));
        }
        return ans;
    }

    private void startNewWorker(String physicalNode) throws IOException, InterruptedException, KeeperException {
        String remoteUser = new String(this.zooKeeper.getData("/physical_nodes/" + physicalNode, false, null));
        String remoteJarFilePath = "/root/AutoHealer/Worker.jar";
        this.logger.info("Sending To : " + remoteUser);
        String sshCommand = "ssh " + remoteUser + " \"java -jar " + remoteJarFilePath + " " + physicalNode + "\"";
        Runtime.getRuntime().exec(sshCommand);
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case NodeChildrenChanged: {
                try {
                    this.masterJob();
                    break;
                }
                catch (IOException | InterruptedException | KeeperException e) {
                    this.logger.error("Could NOT Handle Node Children Changed Event!");
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

