/*
 * Decompiled with CFR 0.152.
 */
package AutoHealerAndLoadBalancing;

import AutoHealerAndLoadBalancing.LeaderElection;
import AutoHealerAndLoadBalancing.OnElectionAction;
import AutoHealerAndLoadBalancing.ServiceRegistry;
import java.io.IOException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
implements Watcher {
    private static final String address = "192.168.184.10:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final int DEFAULT_PORT = 8080;
    private ZooKeeper zooKeeper;
    public static int numberOfInstances;
    public static String pathToFile;
    private final Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        int currentServerPort = args.length == 3 ? Integer.parseInt(args[0]) : 8080;
        numberOfInstances = args.length == 3 ? Integer.parseInt(args[1]) : 4;
        String IP = args.length == 3 ? args[2] : "M_Salameh@127.0.0.1";
        pathToFile = System.getProperty("user.dir") + "Worker.jar";
        Application application = new Application();
        ZooKeeper zooKeeper = application.connectToZookeeper();
        ServiceRegistry serviceRegistry = new ServiceRegistry(zooKeeper, numberOfInstances, pathToFile);
        OnElectionAction onElectionAction = new OnElectionAction(serviceRegistry, currentServerPort);
        LeaderElection leaderElection = new LeaderElection(zooKeeper, onElectionAction);
        leaderElection.volunteerForLeadership(IP);
        leaderElection.reelectLeader();
        application.run();
        application.close();
    }

    public ZooKeeper connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(address, 3000, this);
        return this.zooKeeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
    }

    private void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None: {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    this.logger.info("Successfully connected to Zookeeper");
                    break;
                }
                if (watchedEvent.getState() == Watcher.Event.KeeperState.Disconnected) {
                    ZooKeeper zooKeeper = this.zooKeeper;
                    synchronized (zooKeeper) {
                        this.logger.warn("Disconnected from Zookeeper");
                        this.zooKeeper.notifyAll();
                        break;
                    }
                }
                if (watchedEvent.getState() != Watcher.Event.KeeperState.Closed) break;
                this.logger.info("Closed Successfully");
            }
        }
    }

    static {
        pathToFile = "";
    }
}

