/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.zookeeper.KeeperException;

public class OnElectionAction
implements OnElectionCallback {
    private final ServiceRegistry serviceRegistry;
    private final int port;

    public OnElectionAction(ServiceRegistry serviceRegistry, int port) {
        this.serviceRegistry = serviceRegistry;
        this.port = port;
    }

    @Override
    public void onElectedToBeLeader() {
        this.serviceRegistry.unregisterFromCluster();
        this.serviceRegistry.registerForUpdates();
    }

    @Override
    public void onWorker() {
        try {
            String IP = InetAddress.getLocalHost().getHostAddress();
            String username = System.getProperty("user.name");
            this.serviceRegistry.registerToCluster(username + "@" + IP);
        }
        catch (InterruptedException | UnknownHostException | KeeperException e) {
            e.printStackTrace();
        }
    }
}

