/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class LeaderElection
implements Watcher {
    private static final String AUTOHEALER_ZNODES_PATH = "/physical_nodes";
    private String currentZnodeName;
    private ZooKeeper zooKeeper;
    private OnElectionCallback onElectionCallback;

    public LeaderElection(ZooKeeper zooKeeper, OnElectionCallback onElectionCallback) {
        this.zooKeeper = zooKeeper;
        this.onElectionCallback = onElectionCallback;
    }

    public void volunteerForLeadership() throws InterruptedException, KeeperException {
        String znodePrefix = "/physical_nodes/node_";
        String znodeFullPath = this.zooKeeper.create(znodePrefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        System.out.println(znodeFullPath);
        this.currentZnodeName = znodeFullPath.replace("/physical_nodes/", "");
    }

    public void reelectLeader() throws InterruptedException, KeeperException {
        String predecessorName = "";
        Stat predecessorStat = null;
        while (predecessorStat == null) {
            List<String> children = this.zooKeeper.getChildren(AUTOHEALER_ZNODES_PATH, false);
            Collections.sort(children);
            String smallestChild = children.get(0);
            if (smallestChild.equals(this.currentZnodeName)) {
                System.out.println("I'm a leader");
                try {
                    String IP = InetAddress.getLocalHost().getHostAddress();
                    String username = System.getProperty("user.name") + "@" + IP;
                    this.zooKeeper.setData("/physical_nodes/" + this.currentZnodeName, username.getBytes(), -1);
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
                this.onElectionCallback.onElectedToBeLeader();
                return;
            }
            System.out.println("I'm not a leader");
            int predecessorIndex = children.indexOf(this.currentZnodeName) - 1;
            predecessorName = children.get(predecessorIndex);
            predecessorStat = this.zooKeeper.exists("/physical_nodes/" + predecessorName, this);
        }
        this.onElectionCallback.onWorker();
        System.out.println("Watching znode " + predecessorName);
        System.out.println();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case NodeDeleted: {
                try {
                    this.reelectLeader();
                    break;
                }
                catch (InterruptedException | KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

