/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class LeaderElection
implements Watcher {
    private static final String PHYSICAL_ZNODES_PATH = "/physical_nodes";
    private String currentZnodeName;
    private ZooKeeper zooKeeper;
    private OnElectionCallback onElectionCallback;

    public LeaderElection(ZooKeeper zooKeeper, OnElectionCallback onElectionCallback) {
        this.zooKeeper = zooKeeper;
        this.onElectionCallback = onElectionCallback;
    }

    public String volunteerForLeadership() throws InterruptedException, KeeperException, UnknownHostException {
        String znodePrefix = "/physical_nodes/node_";
        String IP = InetAddress.getLocalHost().getHostAddress();
        String username = System.getProperty("user.name") + "@" + IP;
        String znodeFullPath = this.zooKeeper.create(znodePrefix, username.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        System.out.println(znodeFullPath);
        this.currentZnodeName = znodeFullPath.replace("/physical_nodes/", "");
        return this.currentZnodeName;
    }

    public void reelectLeader() throws InterruptedException, KeeperException {
        String predecessorName = "";
        Stat predecessorStat = null;
        while (predecessorStat == null) {
            List<String> children = this.zooKeeper.getChildren(PHYSICAL_ZNODES_PATH, false);
            Collections.sort(children);
            String smallestChild = children.get(0);
            if (smallestChild.equals(this.currentZnodeName)) {
                System.out.println("I'm a leader");
                this.onElectionCallback.onElectedToBeLeader();
                return;
            }
            System.out.println("I'm not a leader");
            int predecessorIndex = children.indexOf(this.currentZnodeName) - 1;
            predecessorName = children.get(predecessorIndex);
            predecessorStat = this.zooKeeper.exists("/physical_nodes/" + predecessorName, this);
        }
        this.onElectionCallback.onWorker(this.currentZnodeName);
        System.out.println("Watching znode " + predecessorName);
        System.out.println();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case NodeDeleted: {
                try {
                    this.reelectLeader();
                    break;
                }
                catch (InterruptedException | KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

