import org.apache.zookeeper.*;
import org.apache.zookeeper.data.Stat;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


public class LeaderElection implements Watcher
{
    private static final String myAddress = "192.168.184.10:2181";
    private static final String address = "172.29.3.101:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private String ELECTION_NAMESPACE =   "/election";
    private ZooKeeper zooKeeper;
    private String TARET_ZNODE = "/target_znode" ;
    private String currentZnodeName = "";

    private String currentZondeFullName = "";
    private String prevZnode = "";
    private String prevZnodeFullName = "";
    private String leader = "";

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        LeaderElection leaderElection = new LeaderElection();
        leaderElection.connectToZookeeper();
        leaderElection.volunteerForLeader();
        leaderElection.electLeader();
        leaderElection.run();
        leaderElection.close();
    }

    public void electLeader() throws InterruptedException, KeeperException
    {
        synchronized (zooKeeper)
        {
            List<String> children = zooKeeper.getChildren(ELECTION_NAMESPACE, this);
            Collections.sort(children);
            this.leader = children.get(0);
            if (currentZnodeName.equals(leader))
            {
                prevZnode = currentZnodeName;
            }
            else
            {
                prevZnode = children.get(children.indexOf(currentZnodeName) - 1);
                prevZnodeFullName = ELECTION_NAMESPACE + "/" + prevZnode;
                Stat prevExist = zooKeeper.exists(prevZnodeFullName , this);
            }

            System.out.println("prevZnode from ElectLeader : " + prevZnode);
            setLeaderInData();
        }
    }

    private void setLeaderInData() throws InterruptedException, KeeperException
    {
        synchronized (zooKeeper){
        zooKeeper.setData(
                currentZondeFullName,
                leader.getBytes(),
                -1);
        System.out.println("The Leader is Set in Node's Data");
        System.out.println("The Leader is : " + leader);}
    }

    private void volunteerForLeader() throws InterruptedException, KeeperException
    {
        String znodePref = ELECTION_NAMESPACE + "/node_";
        String path = zooKeeper.create(znodePref , new byte[] {} , ZooDefs.Ids.OPEN_ACL_UNSAFE , CreateMode.EPHEMERAL_SEQUENTIAL);
        currentZondeFullName = path;
        this.currentZnodeName = path.replace(ELECTION_NAMESPACE + "/" , "");
        System.out.println("I am Node " + currentZnodeName);
    }

    private void close()
    {
        synchronized (zooKeeper)
        {
            try {
                zooKeeper.close();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
    public void connectToZookeeper() throws IOException
    {
        this.zooKeeper = new ZooKeeper(myAddress, SESSION_TIMEOUT, this);
    }

    public void run() throws InterruptedException
    {
        synchronized (zooKeeper)
        {
                zooKeeper.wait();
        }
    }

    public void process(WatchedEvent watchedEvent)
    {
        switch (watchedEvent.getType())
        {
            case None:
            {
                if (watchedEvent.getState() == Event.KeeperState.SyncConnected) {
                    System.out.println("Successfully connected to ZooKeeper");
                } else if (watchedEvent.getState() == Event.KeeperState.Closed) {
                    System.out.println("Connection Closed");

                    synchronized (zooKeeper) {
                        zooKeeper.notifyAll();
                    }
                } else if (watchedEvent.getState() == Event.KeeperState.Disconnected) {
                    System.out.println("Disconnected");
                    synchronized (zooKeeper) {
                        zooKeeper.notifyAll();
                    }
                }
                break;
            }


            case NodeDeleted:
            {
                try
                {
                    System.out.println("Detecting Node Deleted ");
                    System.out.println("prev full name is :  " + prevZnodeFullName);
                    ///Stat prevExist = zooKeeper.exists(prevZnodeFullName, this);
                    if (leader.equals(prevZnode))
                    {
                        this.leader = currentZnodeName;
                        prevZnode = currentZnodeName;
                        prevZnodeFullName = currentZondeFullName;
                        setLeaderInData();
                    }
                }
                catch (InterruptedException e)
                {
                    throw new RuntimeException(e);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
                break;
            }

            case NodeDataChanged:
            {
                try
                {
                    System.out.println("Detecting Node Data Changed");
                    byte[] newLeader = zooKeeper.getData(prevZnodeFullName, this, new Stat());
                    this.leader = new String(newLeader, StandardCharsets.UTF_8);
                    setLeaderInData();
                }
                catch (InterruptedException e)
                {
                    throw new RuntimeException(e);
                }
                catch (KeeperException e)
                {
                    throw new RuntimeException(e);
                }
                break;
            }

            default:break;
        }
    }
}