/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class LeaderElection
implements Watcher {
    private static final String myAddress = "192.168.184.10:2181";
    private static final String address = "172.29.3.101:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private String ELECTION_NAMESPACE = "/election";
    private ZooKeeper zooKeeper;
    private String TARET_ZNODE = "/target_znode";
    private String currentZnodeName = "";
    private String currentZondeFullName = "";
    private String prevZnode = "";
    private String prevZnodeFullName = "";
    private String leader = "";

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        LeaderElection leaderElection = new LeaderElection();
        leaderElection.connectToZookeeper();
        leaderElection.volunteerForLeader();
        leaderElection.electLeader();
        leaderElection.run();
        leaderElection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void electLeader() throws InterruptedException, KeeperException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            List<String> children = this.zooKeeper.getChildren(this.ELECTION_NAMESPACE, this);
            Collections.sort(children);
            this.leader = children.get(0);
            if (this.currentZnodeName.equals(this.leader)) {
                this.prevZnode = this.currentZnodeName;
            } else {
                this.prevZnode = children.get(children.indexOf(this.currentZnodeName) - 1);
                this.prevZnodeFullName = this.ELECTION_NAMESPACE + "/" + this.prevZnode;
                Stat stat = this.zooKeeper.exists(this.prevZnodeFullName, this);
            }
            System.out.println("prevZnode from ElectLeader : " + this.prevZnode);
            this.setLeaderInData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLeaderInData() throws InterruptedException, KeeperException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.setData(this.currentZondeFullName, this.leader.getBytes(), -1);
            System.out.println("The Leader is Set in Node's Data");
            System.out.println("The Leader is : " + this.leader);
        }
    }

    private void volunteerForLeader() throws InterruptedException, KeeperException {
        String path;
        String znodePref = this.ELECTION_NAMESPACE + "/node_";
        this.currentZondeFullName = path = this.zooKeeper.create(znodePref, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        this.currentZnodeName = path.replace(this.ELECTION_NAMESPACE + "/", "");
        System.out.println("I am Node " + this.currentZnodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            try {
                this.zooKeeper.close();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(myAddress, 3000, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None: {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    System.out.println("Successfully connected to ZooKeeper");
                    break;
                }
                if (watchedEvent.getState() == Watcher.Event.KeeperState.Closed) {
                    System.out.println("Connection Closed");
                    ZooKeeper zooKeeper = this.zooKeeper;
                    synchronized (zooKeeper) {
                        this.zooKeeper.notifyAll();
                        break;
                    }
                }
                if (watchedEvent.getState() != Watcher.Event.KeeperState.Disconnected) break;
                System.out.println("Disconnected");
                ZooKeeper zooKeeper = this.zooKeeper;
                synchronized (zooKeeper) {
                    this.zooKeeper.notifyAll();
                    break;
                }
            }
            case NodeDeleted: {
                try {
                    System.out.println("Detecting Node Deleted ");
                    System.out.println("prev full name is :  " + this.prevZnodeFullName);
                    if (!this.leader.equals(this.prevZnode)) break;
                    this.leader = this.currentZnodeName;
                    this.prevZnode = this.currentZnodeName;
                    this.prevZnodeFullName = this.currentZondeFullName;
                    this.setLeaderInData();
                    break;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
            case NodeDataChanged: {
                try {
                    System.out.println("Detecting Node Data Changed");
                    byte[] newLeader = this.zooKeeper.getData(this.prevZnodeFullName, this, new Stat());
                    this.leader = new String(newLeader, StandardCharsets.UTF_8);
                    this.setLeaderInData();
                    break;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

