/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.locks.LockSupport;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class Worker {
    private static final String ZOOKEEPER_ADDRESS = "192.168.184.10:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String AUTOHEALER_ZNODES_PATH = "/workers";
    private static final float CHANCE_TO_FAIL = 0.001f;
    private final Random random = new Random();
    private ZooKeeper zooKeeper;
    private String myName = "";

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ZOOKEEPER_ADDRESS, 3000, event -> {});
    }

    public void work() throws KeeperException, InterruptedException {
        this.addChildZnode();
        do {
            System.out.println(this.myName + " is Working...");
            LockSupport.parkNanos(1000L);
        } while (!(this.random.nextFloat() < 0.001f));
        System.out.println(this.myName + " encountered Critical error happened");
        throw new RuntimeException(this.myName + " : Oops");
    }

    private void addChildZnode() throws KeeperException, InterruptedException {
        this.myName = this.zooKeeper.create("/workers/worker_", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
    }
}

