/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class AutoHealer
implements Watcher {
    private static final String ZOOKEEPER_ADDRESS = "192.168.184.10:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String AUTOHEALER_ZNODES_PATH = "/workers";
    private final String pathToProgram;
    private final int numberOfWorkers;
    private ZooKeeper zooKeeper;

    public AutoHealer(int numberOfWorkers, String pathToProgram) {
        this.numberOfWorkers = numberOfWorkers;
        this.pathToProgram = pathToProgram;
    }

    public void startWatchingWorkers() throws KeeperException, InterruptedException {
        if (this.zooKeeper.exists(AUTOHEALER_ZNODES_PATH, this) == null) {
            this.zooKeeper.create(AUTOHEALER_ZNODES_PATH, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        this.launchWorkersIfNecessary();
    }

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ZOOKEEPER_ADDRESS, 3000, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
    }

    public void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent event) {
        switch (event.getType()) {
            case None: {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    System.out.println("Successfully connected to Zookeeper");
                    break;
                }
                ZooKeeper zooKeeper = this.zooKeeper;
                synchronized (zooKeeper) {
                    System.out.println("Disconnected from Zookeeper event");
                    this.zooKeeper.notifyAll();
                    break;
                }
            }
            case NodeChildrenChanged: {
                if (!event.getPath().equals(AUTOHEALER_ZNODES_PATH)) break;
                try {
                    this.launchWorkersIfNecessary();
                    break;
                }
                catch (InterruptedException | KeeperException e) {
                    System.out.println("Failed to launch workers: " + e.getMessage());
                }
            }
        }
    }

    private void launchWorkersIfNecessary() throws KeeperException, InterruptedException {
        List<String> workerZnodes = this.zooKeeper.getChildren(AUTOHEALER_ZNODES_PATH, this);
        AtomicInteger existingWorkersNumber = new AtomicInteger(workerZnodes.size());
        if (existingWorkersNumber.get() > 0) {
            System.out.println("Last Child Znode Now is : " + workerZnodes.get(existingWorkersNumber.get() - 1));
        }
        while (existingWorkersNumber.get() < this.numberOfWorkers) {
            Thread thread = new Thread(() -> {
                try {
                    this.startNewWorker();
                    existingWorkersNumber.getAndIncrement();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            thread.start();
        }
        while (existingWorkersNumber.get() > this.numberOfWorkers) {
            String worker = workerZnodes.get(0);
            String workerPath = "/workers/" + worker;
            System.out.println("delete node: /workers/" + worker);
            this.zooKeeper.delete(workerPath, -1);
            existingWorkersNumber.getAndDecrement();
            workerZnodes.remove(0);
        }
    }

    private void startNewWorker() throws IOException {
        File file = new File(this.pathToProgram);
        String command = "java -Dorg.slf4j.simpleLogger.defaultLogLevel=off -jar " + file.getName();
        System.out.println(String.format("Launching worker instance : %s ", command));
        Runtime.getRuntime().exec(command, null, file.getParentFile());
    }
}

