/*
 * Decompiled with CFR 0.152.
 */
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;

public class WebClient {
    private HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private String DEBUG_RESPONSE_KEY = "X-Debug-Info";

    public CompletableFuture<String> sendTask(String url, byte[] requestPayload) {
        CompletableFuture<String> response = new CompletableFuture();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofByteArray(requestPayload)).build();
        response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApply(HttpResponse::body);
        return response;
    }

    public CompletableFuture<String> sendTask(String url, byte[] requestPayload, String headers) {
        CompletableFuture<String> reply = new CompletableFuture();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofByteArray(requestPayload));
        if (headers != null && !headers.isEmpty()) {
            String[] headerLines;
            for (String headerLine : headerLines = headers.split("\n")) {
                String[] headerParts = headerLine.split(":");
                String headerName = headerParts[0].trim();
                String headerValue = headerParts[1].trim();
                requestBuilder.header(headerName, headerValue);
            }
        }
        HttpRequest request = requestBuilder.build();
        reply = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApply(response -> response.headers().map().get(this.DEBUG_RESPONSE_KEY).get(0) + (String)response.body());
        return reply;
    }
}

