#include <stdio.h>
#include <omp.h>
#include <stdlib.h>
#include <math.h>  
#include <stdbool.h>
#include <time.h>
#define total_number_of_rectangles 10000 // Number of rectangles to divide interval to



double interval_start;
double interval_end;
double rectangle_width;
double step;

double CalculateIntegration(int tid , int numThreads)
{
    
    double start = interval_start*total_number_of_rectangles + tid * (interval_end - interval_start)*total_number_of_rectangles/numThreads;
    double end = start + (interval_end - interval_start)*total_number_of_rectangles/numThreads;
    double result = 0.0;

    for (double i = start ; i < end; i += step) 
    {
        double mid = (i+ i+1)/2.0;
        mid /= total_number_of_rectangles;
        double y = mid*mid;
        result += y*rectangle_width;
    }
    return result;
}

int main() 
{
    interval_start = 0;  interval_end = 1;
    rectangle_width = (interval_end - interval_start) / total_number_of_rectangles;
    step = rectangle_width * total_number_of_rectangles;
    
    clock_t start, end;
    double cpu_time_used;

    double sum = 0.0;

    start = clock();
    #pragma omp parallel
    {
        int numThreads = omp_get_num_threads();
        int tid = omp_get_thread_num();
        double localAnswer = CalculateIntegration(tid, numThreads);
        #pragma omp critical
        {
            sum += localAnswer;
        }
    }
    end = clock();
    cpu_time_used = ((double) (end - start)) / CLOCKS_PER_SEC;
    printf("Numerical Integral using OMP : value is %lf and it took time (seconds) = %lf\n", sum , cpu_time_used);
    printf("\nThis Program is written by Mohammed Salameh , It Works for Any Interval \n");

    return 0;
}