/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scanner.PortScanner;
import scanner.PortStatus;

public class PortScannerTest {
    private static final int TIMEOUT = 200;
    private static final int THREAD_COUNT = 16;
    private static final String GOOGLE_IP = "64.233.185.139";
    private ExecutorService es;
    private List<PortStatus> expected;
    private List<PortStatus> actual;

    @Before
    public void setup() {
        this.es = Executors.newFixedThreadPool(16);
        this.expected = new ArrayList<PortStatus>();
        this.actual = new ArrayList<PortStatus>();
    }

    private void getResults(String ip, int portStart, int portEnd) {
        ArrayList<Future<PortStatus>> futures = new ArrayList<Future<PortStatus>>();
        for (int port = portStart; port <= portEnd; ++port) {
            futures.add(PortScanner.isPortOpen(this.es, ip, port, 200));
        }
        this.es.shutdown();
        try {
            if (!this.es.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.es.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.es.shutdownNow();
        }
        ArrayList<PortStatus> resultList = new ArrayList<PortStatus>();
        for (Future future : futures) {
            try {
                resultList.add((PortStatus)future.get(200L, TimeUnit.MILLISECONDS));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.actual = resultList;
    }

    private void runCompare() {
        Assert.assertEquals(this.expected.size(), this.actual.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            PortStatus expStatus = this.expected.get(i);
            PortStatus actStatus = this.actual.get(i);
            Assert.assertEquals(expStatus.getPortNum(), actStatus.getPortNum());
            Assert.assertEquals(expStatus.getIsOpen(), actStatus.getIsOpen());
        }
    }

    @Test
    public void testScanGoogleSinglePort() {
        this.expected.add(new PortStatus(80, true));
        this.getResults(GOOGLE_IP, 80, 80);
        this.runCompare();
    }

    @Test
    public void testScanGoogleMultiplePorts() {
        for (int i = 80; i <= 443; ++i) {
            this.expected.add(new PortStatus(i, i == 80 || i == 443));
        }
        this.getResults(GOOGLE_IP, 80, 443);
        this.runCompare();
    }
}

