/*
 * Decompiled with CFR 0.152.
 */
package driver;

import driver.IPv4Iterator;
import driver.InvalidUserInputException;
import driver.Target;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import scanner.IPHandler;

public final class Parser {
    public static List<Target> run(String[] args) throws InvalidUserInputException {
        String targetPortEnd;
        String targetPortStart;
        ArrayList<Target> ret = new ArrayList<Target>();
        List<Object> IPs = new ArrayList();
        if (args.length < 2 || args.length > 3) {
            throw new InvalidUserInputException("default");
        }
        if (Parser.isValidIPv4Address(args[0]) && Parser.isValidIPv4Address(args[1])) {
            try {
                IPHandler ipHandler = new IPHandler(args[0], args[1]);
                String startIP = ipHandler.getStartIP();
                String endIP = ipHandler.getEndIP();
                IPs = IPv4Iterator.iterateIPv4Addresses(startIP, endIP);
                for (String string : IPs) {
                    Target target = new Target();
                    target.targetIP = string;
                    ret.add(target);
                }
            }
            catch (IPHandler.IPExeption e) {
                throw new RuntimeException(e);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new InvalidUserInputException("ip");
        }
        if (args.length == 2) {
            targetPortStart = "1";
            targetPortEnd = "65535";
        } else if (args[2].contains("-")) {
            int index = args[2].indexOf("-");
            targetPortStart = args[2].substring(0, index);
            targetPortEnd = args[2].substring(index + 1, args[2].length());
        } else {
            targetPortStart = args[2];
            targetPortEnd = args[2];
        }
        try {
            int p1 = Integer.parseInt(targetPortStart);
            int p2 = Integer.parseInt(targetPortEnd);
            for (Target target : ret) {
                target.portRange[0] = p1;
                target.portRange[1] = p2;
            }
        }
        catch (Exception e) {
            throw new InvalidUserInputException("port");
        }
        for (int i = 0; i < ret.size(); ++i) {
            if (Parser.isValidPortNumber(((Target)ret.get((int)i)).portRange[0]) && Parser.isValidPortNumber(((Target)ret.get((int)i)).portRange[1])) continue;
            throw new InvalidUserInputException("port");
        }
        return ret;
    }

    private static boolean isValidPortNumber(int portNum) {
        return 1 <= portNum && portNum <= 65535;
    }

    private static boolean isValidIPv4Address(String ip) {
        try {
            return InetAddress.getByName(ip).getHostAddress().equals(ip);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

