/*
 * Decompiled with CFR 0.152.
 */
package driver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class IPv4Iterator {
    public static List<String> iterateIPv4Addresses(String startIP, String endIP) throws UnknownHostException {
        InetAddress start = InetAddress.getByName(startIP);
        InetAddress end = InetAddress.getByName(endIP);
        byte[] startAddress = start.getAddress();
        byte[] endAddress = end.getAddress();
        long startValue = IPv4Iterator.bytesToLong(startAddress);
        long endValue = IPv4Iterator.bytesToLong(endAddress);
        ArrayList<String> ipAddresses = new ArrayList<String>();
        for (long i = startValue; i <= endValue; ++i) {
            try {
                InetAddress address = InetAddress.getByAddress(IPv4Iterator.longToBytes(i));
                ipAddresses.add(address.getHostAddress());
                continue;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return ipAddresses;
    }

    public static long bytesToLong(byte[] bytes) {
        long result = 0L;
        for (byte b : bytes) {
            result = result << 8 | (long)(b & 0xFF);
        }
        return result;
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[4];
        for (int i = 3; i >= 0; --i) {
            bytes[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return bytes;
    }
}

