/*
 * Decompiled with CFR 0.152.
 */
package driver;

import driver.Target;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import scanner.PortScanner;
import scanner.PortScannerResult;
import scanner.PortStatus;

public class SingleIPDriver {
    private static final int SCAN_TIMEOUT = 200;
    private static final int THREAD_COUNT = Runtime.getRuntime().availableProcessors();

    public static void start(Target t) {
        System.out.println("Scanning " + t.targetIP + ":" + t.portRange[0] + "-" + t.portRange[1]);
        ArrayList<Future<PortStatus>> futureList = new ArrayList<Future<PortStatus>>();
        ArrayList<PortStatus> resultList = new ArrayList<PortStatus>();
        ExecutorService es = Executors.newFixedThreadPool(THREAD_COUNT);
        for (int currPort = t.portRange[0]; currPort <= t.portRange[1]; ++currPort) {
            futureList.add(PortScanner.isPortOpen(es, t.targetIP, currPort, 200));
        }
        es.shutdown();
        try {
            if (!es.awaitTermination(2L, TimeUnit.MINUTES)) {
                es.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            es.shutdownNow();
        }
        for (Future future : futureList) {
            try {
                resultList.add((PortStatus)future.get(2L, TimeUnit.MINUTES));
            }
            catch (Exception e) {
                System.err.println("Timeout reached");
                System.exit(1);
            }
        }
        PortScannerResult r = new PortScannerResult(resultList);
        System.out.println(r);
    }
}

