package org.example;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.*;
import com.mongodb.connection.ClusterDescription;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.util.List;

import static com.mongodb.client.model.Filters.eq;

public class Main
{


    ///use mongos

    private static final String Mongo_URL="mongodb://192.168.184.11:27117"; /*+
            "192.168.184.11:27027," +
            "192.168.184.11:27037" +
            "/?replicaSet=rs1";*/

    private static final String DB_Name = "sample_mflix";

    private static final Double Min_gpa = 90.0;

    public static void main(String[] args)
    {
        /*String cousre = args[0];
        String student = args[1];*/
        String cousre = "Math";
        String student = "Abd";
        double grade = 200;
        MongoDatabase DB = connectToMongoDB();
        //enroll(DB , cousre , student , 15 , grade);
        //enable Sharding
        DB.runCommand(new Document("enable sharding" , DB_Name));

        //create collection
        DB.createCollection("movies");
        //shard a collection
        DB.runCommand(new Document("shardCollection", DB_Name+"."+"movies")
                .append("key", new Document("_id", "hashed")));

    }

    private static void enroll(MongoDatabase DB , String course , String student , int age , double gpa)
    {
        /*if (!isValid(DB , course))
        {
            System.out.println("Not Valid Course");
            return;
        }*/
        MongoCollection<Document> collection = DB.getCollection(course)
                .withWriteConcern(WriteConcern.MAJORITY)
                .withReadPreference(ReadPreference.primaryPreferred());
        if (collection.find(eq("name" , student)).first() != null)
        {
            System.out.println("Student : "+student + " already exists");
            return;
        }
        if (gpa < Min_gpa)
        {
            System.out.println("Please Improve Grade");
            return;
        }
        collection.insertOne(new Document("name" , student).append("age",age).append("gpa",gpa));
        System.out.println("Success!!");
        for (Document doc : collection.find())
        {
            System.out.println(doc);
        }
    }
    private static boolean isValid(MongoDatabase DB , String course)
    {
        for (String co : DB.listCollectionNames())
        {
            if (co.equals(course)) return true;
        }
        return false;
    }
    private static MongoDatabase connectToMongoDB()
    {
        MongoClient mongoClient = MongoClients.create(Mongo_URL);
        return mongoClient.getDatabase(DB_Name);
    }
}