package org.example;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/users-db")
public class UserDB
{
    public static Map<String , User> usersDB = new HashMap<>();
    public static void addUser(User user)
    {
        String id = user.getUserID();
        if (usersDB.containsKey(id)) return;
        usersDB.put(id , user);
    }

    @RequestMapping("/{userID}")
    public static User getUser(@PathVariable("userID")String userID)
    {
        log.info("Query on User with ID : " + userID);
        System.out.println(usersDB.get(userID));
        if (usersDB.containsKey(userID)) return usersDB.get(userID);
        return null;
    }
}
