package org.example;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import java.io.IOException;


public class TestExternalAPI
{
    public static void main(String[] args) throws IOException, JSONException {
        String myAPIKey = "57afea8fc6e142f29f2115632242604";
        String prefURL = "http://api.weatherapi.com/v1/current.json?key="+myAPIKey + "&q=";
        String sufURL = "&aqi=yes";
        String url = prefURL + "London" + sufURL;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();

        HttpGet request = new HttpGet(url);

        HttpResponse response = httpClient.execute(request);

        HttpEntity entity = response.getEntity();

        String jsonResponse = EntityUtils.toString(entity);

        JSONObject json = new JSONObject(jsonResponse);

        // Extract location details
        JSONObject location = json.getJSONObject("location");
        String locationName = location.getString("name");
        String country = location.getString("country");

        // Extract current temperature in Celsius
        JSONObject current = json.getJSONObject("current");
        double tempC = current.getDouble("temp_c");

        // Print the extracted values
        System.out.println("Location Name: " + locationName);
        System.out.println("Temperature in Celsius: " + tempC);
        System.out.println("Country: " + country);

    }
}
