package org.example;


import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;


import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component
@RestController
@RequestMapping("/users")
public class UserService
{
    @Autowired
    RestTemplate restTemplate;

    String UserDBURL = "http://database-service/users-db/";
    String FlightDBURL = "http://database-service/flights-db/";
    String WeatherURL = "http://weather-service/weather/";

    @RequestMapping("/{userID}")
    public List<Flight> getFlights(@PathVariable("userID") String userID)
    {
        log.info("Query on Flights for User with ID : " + userID);
        User user = restTemplate.getForObject(UserDBURL+userID , User.class);
        if (user == null)
        {
            log.warn("No User With ID : " + userID);
            return new ArrayList<>();
        }
        System.out.println("Welcome : " + user.getName());
        List<Flight> ans = new ArrayList<>();

        for (String flightID : user.getFlights())
        {
            Flight flight = restTemplate.getForObject(FlightDBURL+flightID , Flight.class);
            ans.add(flight);
        }
        System.out.println(ans);
        return ans;
    }

    @RequestMapping("/weather/{flightID}")
    public Weather getWeather(@PathVariable("flightID") String flightID)
    {
        log.info("Query on Weather and Forecast for Destination of Flight : " + flightID);
        Flight flight = restTemplate.getForObject(FlightDBURL+flightID , Flight.class);
        if (flight.getDestination().isEmpty() )
        {

            log.warn("No Flight with ID : " + flightID);
            return new Weather();
        }

        String city = flight.getDestination();
        Weather weather = restTemplate.getForObject(WeatherURL+city , Weather.class);

        System.out.println(weather);

        return weather;
    }
}
