package org.database;

import java.util.ArrayList;
import java.util.List;

public class User
{
    private String userID;
    private String name;
    private List<String> flights = new ArrayList<>();

    public User(String userID, String name, Flight flight)
    {
        this.userID = userID;
        this.name = name;
        flights.add(flight.getFlightID());
        FlightDB.addFlight(flight);
    }

    public String getUserID() {
        return userID;
    }

    public List<Flight> getFlights()
    {
        List<Flight> ans = new ArrayList<>();
        for (String id : flights)
        {
            ans.add(FlightDB.getFlight(id));
        }
        return ans;
    }
}
