package org.wheatherservice;

import org.database.Flight;
import org.database.FlightDB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;


@RestController
@RequestMapping("/weather")
public class WeatherService
{
    @Autowired
    RestTemplate restTemplate;

    String FlightDBURL = "http://localhost:8081/flights-db/";
    String myAPIKey = "d5e468d45e234c749b9123443230105";
    String prefURL = "http://api.weatherapi.com/v1/current.json?key="+myAPIKey + "&q=";
    String sufURL = "&aqi=yes";
    @RequestMapping("/{city}")
    public Weather getWeather(@PathVariable("city") String city)
    {
        if (city.isEmpty())
        {
            return new Weather();
        }

        String url = prefURL + city + sufURL;
        Weather weather = restTemplate.getForObject(url , Weather.class);
        return weather;
    }
}
