package org.example;

import lombok.extern.slf4j.Slf4j;
import org.codehaus.jettison.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;

@Component
@Slf4j
@RestController
@RequestMapping("/weather")
public class WeatherService
{
    @Autowired
    RestTemplate restTemplate;
    /*@Value("${api.key}")
    String myAPIKey;*/

    String myAPIKey = "57afea8fc6e142f29f2115632242604";
    String prefURL = "http://api.weatherapi.com/v1/current.json?key="+ myAPIKey + "&q=";
    String sufURL = "&aqi=yes";
    @RequestMapping("/{city}")
    public Weather getWeather(@PathVariable("city") String city) throws IOException
    {
        if (city.isEmpty())
        {
            log.warn("Request With Empty City");
            System.out.println("City is Empty");
            return new Weather();
        }
        log.info("Weather Request for : " + city);
        Weather weather = new Weather();
        try
        {
            weather = new Weather(prefURL + city + sufURL);

        } catch (JSONException e)
        {
            log.error("JSON Parsing Error in External API Request for City : " + city);
        }
        return weather;
    }
}
