package org.database;

import java.util.ArrayList;
import java.util.List;

public class User
{
    private String userID;
    private String name;
    private List<String> flights;

    public User () {}

    public User(String userID, String name)
    {
        this.userID = userID;
        this.name = name;
        flights = new ArrayList<>();
    }
    public void addFlight(Flight flight)
    {
        flights.add(flight.getFlightID());
    }

    public String getUserID() {
        return userID;
    }

    public String getName() {
        return name;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getFlights() {
        return flights;
    }

    public void setFlights(List<String> flights) {
        this.flights = flights;
    }

    @Override
    public String toString()
    {
        String ans = "Name : "+name+"\n";
        ans += "ID : " + userID + "\n";
        for (String f:flights)
        {
            ans += FlightDB.getFlight(f);
            ans+="\n";
        }
        return ans;
    }

}
