package org.example;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import java.io.IOException;

public class Weather
{
    String cityName;
    String Country;
    double temperature;
    public Weather()
    {

    }

    public Weather(String url) throws IOException, JSONException
    {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();

        HttpGet request = new HttpGet(url);

        HttpResponse response = httpClient.execute(request);

        HttpEntity entity = response.getEntity();

        String jsonResponse = EntityUtils.toString(entity);

        JSONObject json = new JSONObject(jsonResponse);

        JSONObject location = json.getJSONObject("location");
        String locationName = location.getString("name");
        String country = location.getString("country");

        JSONObject current = json.getJSONObject("current");
        double tempC = current.getDouble("temp_c");

        this.cityName = locationName;
        this.Country = country;
        this.temperature = tempC;

    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountry() {
        return Country;
    }

    public void setCountry(String country) {
        Country = country;
    }

    public double getTemperature() {
        return temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public String toString()
    {
        if (cityName.isEmpty())
        {
            return "No Information to be Printed";
        }
        String ans = "Location Name: " + cityName+"\n" +
                    "Temperature in Celsius: " + temperature + "\n" +
                    "Country: " + Country+"\n";
        return ans;

    }
}
