package org.wheatherservice;

import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.database.Flight;
import org.database.FlightDB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.net.http.HttpClient;


@RestController
@RequestMapping("/weather")
public class WeatherService
{
    @Autowired
    RestTemplate restTemplate;
    String myAPIKey = "57afea8fc6e142f29f2115632242604";
    String prefURL = "http://api.weatherapi.com/v1/current.json?key="+myAPIKey + "&q=";
    String sufURL = "&aqi=yes";
    @RequestMapping("/{city}")
    public Weather getWeather(@PathVariable("city") String city) throws IOException {
        if (city.isEmpty())
        {
            return new Weather();
        }
        Weather weather = new Weather();
        try
        {
            weather = new Weather(prefURL + city + sufURL);
        } catch (JSONException e)
        {
            //log
        }
        return weather;
    }
}
