package org.example;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/flights-db")
public class FlightDB
{
    public static Map<String , Flight> flightsDB = new HashMap<>();
    public static void addFlight(Flight flight)
    {
        String id = flight.getFlightID();
        if (flightsDB.containsKey(id)) return;
        flightsDB.put(id , flight);
    }

    @RequestMapping("/{flightID}")
    public static Flight getFlight(@PathVariable("flightID") String flightID)
    {
        if (flightsDB.containsKey(flightID)) return flightsDB.get(flightID);
        return new Flight("",new Date(),"");
    }
}
