/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final Logger logger = LoggerFactory.getLogger(WebServer.class);
    private final int port;
    private HttpServer server;

    public WebServer(int port) throws IOException, InterruptedException {
        this.port = port;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        int serverPort = 8001;
        if (args.length == 1) {
            serverPort = Integer.parseInt(args[0]);
        }
        WebServer webServer = new WebServer(serverPort);
        webServer.startServer();
        System.out.println("Server is listening on port " + serverPort);
        logger.info("Server is listening on port " + serverPort);
    }

    public void startServer() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            logger.info("Server Started at : " + System.nanoTime());
            System.out.println("Server Started");
        }
        catch (IOException e) {
            logger.error("Server failed to Start at : " + System.nanoTime());
            System.out.println("Server failed");
            throw new RuntimeException(e);
        }
        HttpContext htmlContext = this.server.createContext("/");
        htmlContext.setHandler(this::handleHtmlRequest);
        this.server.setExecutor(Executors.newFixedThreadPool(8));
        this.server.start();
    }

    private void handleHtmlRequest(HttpExchange exchange) throws IOException {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        String filePath = "index" + this.port + ".html";
        File file = new File(filePath);
        byte[] fileBytes = Files.readAllBytes(file.toPath());
        exchange.getResponseHeaders().set("Content-Type", "text/html");
        exchange.sendResponseHeaders(200, fileBytes.length);
        OutputStream outputStream = exchange.getResponseBody();
        outputStream.write(fileBytes);
        outputStream.flush();
        outputStream.close();
        exchange.close();
    }
}

