import java.util.ArrayList;
import java.util.List;

public class FibonacciSeries
{
    private List<Long> Fibs;
    public FibonacciSeries()
    {
        Fibs = new ArrayList<>();
        Fibs.add(0L);
        Fibs.add(1L);
    }
    public long CalculateFibsRec(int number)
    {
        if (number <= 1)
        {
            return number;
        }
        long p1 = CalculateFibsRec(number-1);
        long p2 = CalculateFibsRec(number-2);
        return p1+p2;
    }
    public long CalculateFibsIter(int number)
    {
        if (Fibs.size() >= number) /// It Is Pre-Calced
        {
            return Fibs.get(number);
        }
        /**
         * Not Pre-Calced so we start filling from where we stopped at last !!
         * No Need to Re-Calc from Beginning !!!
         * */
        int start = Fibs.size();
        for (int i=start ; i<= number+1  ; i++)
        {
            Fibs.add(Fibs.get(i-2) + Fibs.get(i-1));
        }
        return Fibs.get(number);
    }
}
