import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class SearchForPrimesThreadTest extends TestCase
{
    private int Start=6000000;
    private int End=10000000;
    private int ThreadsNum=4;
    private int step=(End - Start +1)/4;

    private List<Integer> primes;

    public void testSearchForPrimesThreadTest()
    {
      //  ProcessData();

        List<SearchForPrimesThread> primesThreads = new ArrayList<>();
        for (int i=1 ; i <= ThreadsNum ; i++)
        {
            int st = (i-1)*step;
            int en = i*step;
            SearchForPrimes searchForPrimes = new SearchForPrimes(st , en);
            SearchForPrimesThread searchForPrimesThread = new SearchForPrimesThread(searchForPrimes);
            primesThreads.add(searchForPrimesThread);
        }
        long startTimer = System.currentTimeMillis();
        primes = new ArrayList<>();
        for (SearchForPrimesThread searchForPrimesThread : primesThreads)
        {
            searchForPrimesThread.start();
        }

        for (SearchForPrimesThread searchForPrimesThread : primesThreads)
        {
            try
            {
                searchForPrimesThread.join();
                primes.addAll(searchForPrimesThread.getPrimes());
            }
            catch (InterruptedException e)
            {
                throw new RuntimeException(e);
            }
        }
        long endTimer = System.currentTimeMillis();

        System.out.println("Time Taken = " + (endTimer-startTimer));

        System.out.println("size = " + (primes.size()));

        /**for (int i=0 ; i<primes.size() ; i++)
        {
            System.out.println(primes.get(i));
        }*/
    }
    private void ProcessData()
    {
        System.out.println("Enter Start and End of Interval you want to" +
                "look for Prime numbers in! ");
        System.out.println("Please Make sure to insert positive integers and start is less than end");
        Scanner scanner = new Scanner(System.in);

        System.out.println("Enter Start Value : ");
        this.Start = scanner.nextInt();

        System.out.println("Enter End Value : ");
        this.End = scanner.nextInt();

        System.out.println("Enter Number of Threads To Parallelize Calculations (Positive Only) ");
        this.ThreadsNum = scanner.nextInt();

        this.step = (End - Start + 1)/ThreadsNum;

        return;

    }
}
