/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.TransactionInfo;
import com.example.TransactionInfoSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.LongSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyProducer {
    private static final String BOOTSTRAP_SERVERS = "192.168.181.136:9092";
    private static final Logger log = LoggerFactory.getLogger(MyProducer.class);
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static boolean logTransaction(TransactionInfo transactionInfo, String topic) {
        RecordMetadata recordMetadata;
        log.info("Registering a transaction for Mr/Ms: " + transactionInfo.getName());
        TransactionInfoSerializer valueSerializer = new TransactionInfoSerializer();
        try {
            byte[] valueBytes = valueSerializer.serialize(topic, transactionInfo);
        }
        catch (SerializationException e) {
            log.error("Transaction for Mr/Ms: " + transactionInfo.getName() + " could not be serialized");
            return false;
        }
        Producer<Long, TransactionInfo> kafkaProducer = MyProducer.createKafkaProducer(BOOTSTRAP_SERVERS);
        long timeStamp = System.currentTimeMillis();
        ProducerRecord<Long, TransactionInfo> record = new ProducerRecord<Long, TransactionInfo>(topic, timeStamp, transactionInfo);
        try {
            recordMetadata = kafkaProducer.send(record).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Could not send data to Kafka or could not get metadata");
            return false;
        }
        log.info(String.format("Record for Mr/Ms: %s - with (key: %s, value: %s), was sent to (partition: %d, offset: %d)", transactionInfo.getName(), record.key(), ((Object)record.value()).toString(), recordMetadata.partition(), recordMetadata.offset()));
        System.out.println(String.format("Record for Mr/Ms: %s - with (key: %s, value: %s), was sent to (partition: %d, offset: %d)", transactionInfo.getName(), record.key(), ((Object)record.value()).toString(), recordMetadata.partition(), recordMetadata.offset()));
        kafkaProducer.flush();
        kafkaProducer.close();
        return true;
    }

    public static Producer<Long, TransactionInfo> createKafkaProducer(String bootstrapServers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("client.id", "events-producer");
        properties.put("key.serializer", LongSerializer.class.getName());
        properties.put("value.serializer", TransactionInfoSerializer.class.getName());
        return new KafkaProducer<Long, TransactionInfo>(properties);
    }
}

