/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.remote.server;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.boot.devtools.remote.server.Dispatcher;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;

public class DispatcherFilter
implements Filter {
    private final Dispatcher dispatcher;

    public DispatcherFilter(Dispatcher dispatcher) {
        Assert.notNull((Object)dispatcher, "Dispatcher must not be null");
        this.dispatcher = dispatcher;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletServerHttpRequest serverRequest = new ServletServerHttpRequest(request);
        ServletServerHttpResponse serverResponse = new ServletServerHttpResponse(response);
        if (!this.dispatcher.handle(serverRequest, serverResponse)) {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
    }
}

