/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.env;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.devtools.logger.DevToolsLogFactory;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.boot.devtools.system.DevToolsEnablementDeducer;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.NativeDetector;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.log.LogMessage;
import org.springframework.util.ClassUtils;

@Order(value=0x7FFFFFFF)
public class DevToolsPropertyDefaultsPostProcessor
implements EnvironmentPostProcessor {
    private static final Log logger = DevToolsLogFactory.getLog(DevToolsPropertyDefaultsPostProcessor.class);
    private static final String ENABLED = "spring.devtools.add-properties";
    private static final String WEB_LOGGING = "logging.level.web";
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"org.springframework.web.context.ConfigurableWebEnvironment", "org.springframework.boot.web.reactive.context.ConfigurableReactiveWebEnvironment"};
    private static final Map<String, Object> PROPERTIES = NativeDetector.inNativeImage() ? Collections.emptyMap() : DevToolsPropertyDefaultsPostProcessor.loadDefaultProperties();

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        if (DevToolsEnablementDeducer.shouldEnable(Thread.currentThread()) && this.isLocalApplication(environment2)) {
            if (this.canAddProperties(environment2)) {
                logger.info(LogMessage.format("Devtools property defaults active! Set '%s' to 'false' to disable", (Object)ENABLED));
                environment2.getPropertySources().addLast(new MapPropertySource("devtools", PROPERTIES));
            }
            if (this.isWebApplication(environment2) && !environment2.containsProperty(WEB_LOGGING)) {
                logger.info(LogMessage.format("For additional web related logging consider setting the '%s' property to 'DEBUG'", (Object)WEB_LOGGING));
            }
        }
    }

    private boolean isLocalApplication(ConfigurableEnvironment environment2) {
        return environment2.getPropertySources().get("remoteUrl") == null;
    }

    private boolean canAddProperties(Environment environment2) {
        if (environment2.getProperty(ENABLED, Boolean.class, true).booleanValue()) {
            return this.isRestarterInitialized() || this.isRemoteRestartEnabled(environment2);
        }
        return false;
    }

    private boolean isRestarterInitialized() {
        try {
            Restarter restarter = Restarter.getInstance();
            return restarter != null && restarter.getInitialUrls() != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isRemoteRestartEnabled(Environment environment2) {
        return environment2.containsProperty("spring.devtools.remote.secret");
    }

    private boolean isWebApplication(Environment environment2) {
        for (String candidate : WEB_ENVIRONMENT_CLASSES) {
            Class<?> environmentClass = this.resolveClassName(candidate, environment2.getClass().getClassLoader());
            if (environmentClass == null || !environmentClass.isInstance(environment2)) continue;
            return true;
        }
        return false;
    }

    private Class<?> resolveClassName(String candidate, ClassLoader classLoader) {
        try {
            return ClassUtils.resolveClassName(candidate, classLoader);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static Map<String, Object> loadDefaultProperties() {
        Properties properties = new Properties();
        try (InputStream stream = DevToolsPropertyDefaultsPostProcessor.class.getResourceAsStream("devtools-property-defaults.properties");){
            if (stream == null) {
                throw new RuntimeException("Failed to load devtools-property-defaults.properties because it doesn't exist");
            }
            properties.load(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load devtools-property-defaults.properties", ex);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return Collections.unmodifiableMap(map);
    }
}

