/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleRegistry;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;

public class DefaultSslBundleRegistry
implements SslBundleRegistry,
SslBundles {
    private final Map<String, SslBundle> bundles = new ConcurrentHashMap<String, SslBundle>();

    public DefaultSslBundleRegistry() {
    }

    public DefaultSslBundleRegistry(String name, SslBundle bundle) {
        this.registerBundle(name, bundle);
    }

    @Override
    public void registerBundle(String name, SslBundle bundle) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull((Object)bundle, "Bundle must not be null");
        SslBundle previous = this.bundles.putIfAbsent(name, bundle);
        Assert.state(previous == null, () -> "Cannot replace existing SSL bundle '%s'".formatted(name));
    }

    @Override
    public SslBundle getBundle(String name) {
        Assert.notNull((Object)name, "Name must not be null");
        SslBundle bundle = this.bundles.get(name);
        if (bundle == null) {
            throw new NoSuchSslBundleException(name, "SSL bundle name '%s' cannot be found".formatted(name));
        }
        return bundle;
    }
}

