/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.sql.DatabaseMetaData;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.database.sqlserver.SQLServerConfigurationExtension;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayConnectionDetails;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.flyway.FlywaySchemaManagementProvider;
import org.springframework.boot.autoconfigure.flyway.ResourceProviderCustomizer;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@ConditionalOnClass(value={Flyway.class})
@Conditional(value={FlywayDataSourceCondition.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, matchIfMissing=true)
@Import(value={DatabaseInitializationDependencyConfigurer.class})
@ImportRuntimeHints(value={FlywayAutoConfigurationRuntimeHints.class})
public class FlywayAutoConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    public StringOrNumberToMigrationVersionConverter stringOrNumberMigrationVersionConverter() {
        return new StringOrNumberToMigrationVersionConverter();
    }

    @Bean
    public FlywaySchemaManagementProvider flywayDefaultDdlModeProvider(ObjectProvider<Flyway> flyways) {
        return new FlywaySchemaManagementProvider(flyways);
    }

    static class StringOrNumberToMigrationVersionConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;

        StringOrNumberToMigrationVersionConverter() {
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String value = ObjectUtils.nullSafeToString(source);
            return MigrationVersion.fromVersion((String)value);
        }

        static {
            HashSet<GenericConverter.ConvertiblePair> types = new HashSet<GenericConverter.ConvertiblePair>(2);
            types.add(new GenericConverter.ConvertiblePair(String.class, MigrationVersion.class));
            types.add(new GenericConverter.ConvertiblePair(Number.class, MigrationVersion.class));
            CONVERTIBLE_TYPES = Collections.unmodifiableSet(types);
        }
    }

    static final class PropertiesFlywayConnectionDetails
    implements FlywayConnectionDetails {
        private final FlywayProperties properties;

        PropertiesFlywayConnectionDetails(FlywayProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getUsername() {
            return this.properties.getUser();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public String getJdbcUrl() {
            return this.properties.getUrl();
        }

        @Override
        public String getDriverClassName() {
            return this.properties.getDriverClassName();
        }
    }

    static class FlywayAutoConfigurationRuntimeHints
    implements RuntimeHintsRegistrar {
        FlywayAutoConfigurationRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.resources().registerPattern("db/migration/*");
        }
    }

    static final class FlywayDataSourceCondition
    extends AnyNestedCondition {
        FlywayDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.flyway", name={"url"})
        private static final class FlywayUrlCondition {
            private FlywayUrlCondition() {
            }
        }

        @ConditionalOnBean(value={JdbcConnectionDetails.class})
        private static final class JdbcConnectionDetailsCondition {
            private JdbcConnectionDetailsCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    private static class LocationResolver {
        private static final String VENDOR_PLACEHOLDER = "{vendor}";
        private final DataSource dataSource;

        LocationResolver(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        List<String> resolveLocations(List<String> locations) {
            if (this.usesVendorLocation(locations)) {
                DatabaseDriver databaseDriver = this.getDatabaseDriver();
                return this.replaceVendorLocations(locations, databaseDriver);
            }
            return locations;
        }

        private List<String> replaceVendorLocations(List<String> locations, DatabaseDriver databaseDriver) {
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                return locations;
            }
            String vendor = databaseDriver.getId();
            return locations.stream().map(location -> location.replace(VENDOR_PLACEHOLDER, vendor)).toList();
        }

        private DatabaseDriver getDatabaseDriver() {
            try {
                String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, DatabaseMetaData::getURL);
                return DatabaseDriver.fromJdbcUrl(url);
            }
            catch (MetaDataAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean usesVendorLocation(Collection<String> locations) {
            for (String location : locations) {
                if (!location.contains(VENDOR_PLACEHOLDER)) continue;
                return true;
            }
            return false;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JdbcUtils.class})
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={FlywayProperties.class})
    public static class FlywayConfiguration {
        @Bean
        ResourceProviderCustomizer resourceProviderCustomizer() {
            return new ResourceProviderCustomizer();
        }

        @Bean
        @ConditionalOnMissingBean(value={FlywayConnectionDetails.class})
        PropertiesFlywayConnectionDetails flywayConnectionDetails(FlywayProperties properties) {
            return new PropertiesFlywayConnectionDetails(properties);
        }

        @Deprecated(since="3.0.0", forRemoval=true)
        public Flyway flyway(FlywayProperties properties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<JavaMigration> javaMigrations, ObjectProvider<Callback> callbacks) {
            return this.flyway(properties, new PropertiesFlywayConnectionDetails(properties), resourceLoader, dataSource, flywayDataSource, fluentConfigurationCustomizers, javaMigrations, callbacks, new ResourceProviderCustomizer());
        }

        @Bean
        Flyway flyway(FlywayProperties properties, FlywayConnectionDetails connectionDetails, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<JavaMigration> javaMigrations, ObjectProvider<Callback> callbacks, ResourceProviderCustomizer resourceProviderCustomizer) {
            FluentConfiguration configuration = new FluentConfiguration(resourceLoader.getClassLoader());
            this.configureDataSource(configuration, flywayDataSource.getIfAvailable(), dataSource.getIfUnique(), connectionDetails);
            this.configureProperties(configuration, properties);
            this.configureCallbacks(configuration, callbacks.orderedStream().toList());
            this.configureJavaMigrations(configuration, javaMigrations.orderedStream().toList());
            fluentConfigurationCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(configuration));
            resourceProviderCustomizer.customize(configuration);
            return configuration.load();
        }

        private void configureDataSource(FluentConfiguration configuration, DataSource flywayDataSource, DataSource dataSource, FlywayConnectionDetails connectionDetails) {
            DataSource migrationDataSource = this.getMigrationDataSource(flywayDataSource, dataSource, connectionDetails);
            configuration.dataSource(migrationDataSource);
        }

        private DataSource getMigrationDataSource(DataSource flywayDataSource, DataSource dataSource, FlywayConnectionDetails connectionDetails) {
            if (flywayDataSource != null) {
                return flywayDataSource;
            }
            String url = connectionDetails.getJdbcUrl();
            if (url != null) {
                DataSourceBuilder<SimpleDriverDataSource> builder = DataSourceBuilder.create().type(SimpleDriverDataSource.class);
                builder.url(url);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            String user = connectionDetails.getUsername();
            if (user != null && dataSource != null) {
                DataSourceBuilder<SimpleDriverDataSource> builder = DataSourceBuilder.derivedFrom(dataSource).type(SimpleDriverDataSource.class);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            Assert.state(dataSource != null, "Flyway migration DataSource missing");
            return dataSource;
        }

        private void applyConnectionDetails(FlywayConnectionDetails connectionDetails, DataSourceBuilder<?> builder) {
            builder.username(connectionDetails.getUsername());
            builder.password(connectionDetails.getPassword());
            String driverClassName = connectionDetails.getDriverClassName();
            if (StringUtils.hasText(driverClassName)) {
                builder.driverClassName(driverClassName);
            }
        }

        private void configureProperties(FluentConfiguration configuration, FlywayProperties properties) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            String[] locations = new LocationResolver(configuration.getDataSource()).resolveLocations(properties.getLocations()).toArray(new String[0]);
            map.from(properties.isFailOnMissingLocations()).to(arg_0 -> ((FluentConfiguration)configuration).failOnMissingLocations(arg_0));
            map.from(locations).to(arg_0 -> ((FluentConfiguration)configuration).locations(arg_0));
            map.from(properties.getEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).encoding(arg_0));
            map.from(properties.getConnectRetries()).to(arg_0 -> ((FluentConfiguration)configuration).connectRetries(arg_0));
            map.from(properties.getConnectRetriesInterval()).as(Duration::getSeconds).as(Long::intValue).to(arg_0 -> ((FluentConfiguration)configuration).connectRetriesInterval(arg_0));
            map.from(properties.getLockRetryCount()).to(arg_0 -> ((FluentConfiguration)configuration).lockRetryCount(arg_0));
            map.from(properties.getDefaultSchema()).to(arg_0 -> ((FluentConfiguration)configuration).defaultSchema(arg_0));
            map.from(properties.getSchemas()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).schemas(arg_0));
            map.from(properties.isCreateSchemas()).to(arg_0 -> ((FluentConfiguration)configuration).createSchemas(arg_0));
            map.from(properties.getTable()).to(arg_0 -> ((FluentConfiguration)configuration).table(arg_0));
            map.from(properties.getTablespace()).to(arg_0 -> ((FluentConfiguration)configuration).tablespace(arg_0));
            map.from(properties.getBaselineDescription()).to(arg_0 -> ((FluentConfiguration)configuration).baselineDescription(arg_0));
            map.from(properties.getBaselineVersion()).to(arg_0 -> ((FluentConfiguration)configuration).baselineVersion(arg_0));
            map.from(properties.getInstalledBy()).to(arg_0 -> ((FluentConfiguration)configuration).installedBy(arg_0));
            map.from(properties.getPlaceholders()).to(arg_0 -> ((FluentConfiguration)configuration).placeholders(arg_0));
            map.from(properties.getPlaceholderPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderPrefix(arg_0));
            map.from(properties.getPlaceholderSuffix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderSuffix(arg_0));
            map.from(properties.getPlaceholderSeparator()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderSeparator(arg_0));
            map.from(properties.isPlaceholderReplacement()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderReplacement(arg_0));
            map.from(properties.getSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationPrefix(arg_0));
            map.from(properties.getSqlMigrationSuffixes()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSuffixes(arg_0));
            map.from(properties.getSqlMigrationSeparator()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSeparator(arg_0));
            map.from(properties.getRepeatableSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).repeatableSqlMigrationPrefix(arg_0));
            map.from(properties.getTarget()).to(arg_0 -> ((FluentConfiguration)configuration).target(arg_0));
            map.from(properties.isBaselineOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).baselineOnMigrate(arg_0));
            map.from(properties.isCleanDisabled()).to(arg_0 -> ((FluentConfiguration)configuration).cleanDisabled(arg_0));
            map.from(properties.isCleanOnValidationError()).to(arg_0 -> ((FluentConfiguration)configuration).cleanOnValidationError(arg_0));
            map.from(properties.isGroup()).to(arg_0 -> ((FluentConfiguration)configuration).group(arg_0));
            map.from(properties.isMixed()).to(arg_0 -> ((FluentConfiguration)configuration).mixed(arg_0));
            map.from(properties.isOutOfOrder()).to(arg_0 -> ((FluentConfiguration)configuration).outOfOrder(arg_0));
            map.from(properties.isSkipDefaultCallbacks()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultCallbacks(arg_0));
            map.from(properties.isSkipDefaultResolvers()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultResolvers(arg_0));
            map.from(properties.isValidateMigrationNaming()).to(arg_0 -> ((FluentConfiguration)configuration).validateMigrationNaming(arg_0));
            map.from(properties.isValidateOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).validateOnMigrate(arg_0));
            map.from(properties.getInitSqls()).whenNot(CollectionUtils::isEmpty).as(initSqls -> StringUtils.collectionToDelimitedString(initSqls, "\n")).to(arg_0 -> ((FluentConfiguration)configuration).initSql(arg_0));
            map.from(properties.getScriptPlaceholderPrefix()).to(prefix -> configuration.scriptPlaceholderPrefix(prefix));
            map.from(properties.getScriptPlaceholderSuffix()).to(suffix -> configuration.scriptPlaceholderSuffix(suffix));
            this.configureExecuteInTransaction(configuration, properties, map);
            map.from(properties::getLoggers).to(arg_0 -> ((FluentConfiguration)configuration).loggers(arg_0));
            map.from(properties.getBatch()).to(arg_0 -> ((FluentConfiguration)configuration).batch(arg_0));
            map.from(properties.getDryRunOutput()).to(arg_0 -> ((FluentConfiguration)configuration).dryRunOutput(arg_0));
            map.from(properties.getErrorOverrides()).to(arg_0 -> ((FluentConfiguration)configuration).errorOverrides(arg_0));
            map.from(properties.getLicenseKey()).to(arg_0 -> ((FluentConfiguration)configuration).licenseKey(arg_0));
            map.from(properties.getOracleSqlplus()).to(oracleSqlplus -> configuration.oracleSqlplus(oracleSqlplus.booleanValue()));
            map.from(properties.getOracleSqlplusWarn()).to(oracleSqlplusWarn -> configuration.oracleSqlplusWarn(oracleSqlplusWarn.booleanValue()));
            map.from(properties.getOracleKerberosCacheFile()).to(oracleKerberosCacheFile -> configuration.oracleKerberosCacheFile(oracleKerberosCacheFile));
            map.from(properties.getStream()).to(arg_0 -> ((FluentConfiguration)configuration).stream(arg_0));
            map.from(properties.getUndoSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).undoSqlMigrationPrefix(arg_0));
            map.from(properties.getCherryPick()).to(arg_0 -> ((FluentConfiguration)configuration).cherryPick(arg_0));
            map.from(properties.getJdbcProperties()).whenNot(Map::isEmpty).to(arg_0 -> ((FluentConfiguration)configuration).jdbcProperties(arg_0));
            map.from(properties.getKerberosConfigFile()).to(arg_0 -> ((FluentConfiguration)configuration).kerberosConfigFile(arg_0));
            map.from(properties.getOutputQueryResults()).to(arg_0 -> ((FluentConfiguration)configuration).outputQueryResults(arg_0));
            map.from(properties.getSqlServerKerberosLoginFile()).whenNonNull().to(sqlServerKerberosLoginFile -> this.configureSqlServerKerberosLoginFile(configuration, (String)sqlServerKerberosLoginFile));
            map.from(properties.getSkipExecutingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).skipExecutingMigrations(arg_0));
            map.from(properties.getIgnoreMigrationPatterns()).whenNot(List::isEmpty).as(patterns -> patterns.toArray(new String[0])).to(arg_0 -> ((FluentConfiguration)configuration).ignoreMigrationPatterns(arg_0));
            map.from(properties.getDetectEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).detectEncoding(arg_0));
        }

        private void configureExecuteInTransaction(FluentConfiguration configuration, FlywayProperties properties, PropertyMapper map) {
            try {
                map.from(properties.isExecuteInTransaction()).to(arg_0 -> ((FluentConfiguration)configuration).executeInTransaction(arg_0));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void configureSqlServerKerberosLoginFile(FluentConfiguration configuration, String sqlServerKerberosLoginFile) {
            SQLServerConfigurationExtension sqlServerConfigurationExtension = (SQLServerConfigurationExtension)configuration.getPluginRegister().getPlugin(SQLServerConfigurationExtension.class);
            Assert.state(sqlServerConfigurationExtension != null, "Flyway SQL Server extension missing");
            sqlServerConfigurationExtension.setKerberosLoginFile(sqlServerKerberosLoginFile);
        }

        private void configureCallbacks(FluentConfiguration configuration, List<Callback> callbacks) {
            if (!callbacks.isEmpty()) {
                configuration.callbacks(callbacks.toArray(new Callback[0]));
            }
        }

        private void configureJavaMigrations(FluentConfiguration flyway, List<JavaMigration> migrations) {
            if (!migrations.isEmpty()) {
                flyway.javaMigrations(migrations.toArray(new JavaMigration[0]));
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayMigrationInitializer flywayInitializer(Flyway flyway, ObjectProvider<FlywayMigrationStrategy> migrationStrategy) {
            return new FlywayMigrationInitializer(flyway, migrationStrategy.getIfAvailable());
        }
    }
}

